using System;
using System.IO;
using System.Xml;
using System.Collections;
using System.Runtime.Remoting;

using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;

namespace Team_Project.PersistencyManagers.Storages
{
	public class RemoteStorage : IStorage
	{
		protected IStorage lrs = null;
        
		public RemoteStorage(XmlNode cfg,string copyName)
		{
			string Port;
			string Protocol;
			string Resource;

			XmlNode copyNode = cfg.SelectSingleNode("RemoteCopy[@ID=\"" + copyName + "\"]");
			
			if(copyNode == null)
				copyNode = cfg.SelectSingleNode("Defaults");
			
			Port = ReadConfig(copyNode,"Port");
			Protocol = ReadConfig(copyNode,"Protocol");
			Resource = ReadConfig(copyNode,"Resource");

/*			if(ChannelServices.GetChannel("Client")==null)
			{
				IDictionary prop = new Hashtable();
				prop["name"] = "Client";
				prop["port"] = "4000";

				HttpClientChannel channel = new HttpClientChannel(prop,null);
				ChannelServices.RegisterChannel(channel);
			}*/
			//TODO: risolvere il nome
            string debug = string.Format("{0}://{1}:{2}/{3}",Protocol,ReadConfig(copyNode,"Address"),Port,Resource);
			RemoteStorageFactory fact = (RemoteStorageFactory)RemotingServices.Connect(typeof(RemoteStorageFactory),debug);
			lrs = fact.BuildStorage(cfg.Attributes["CopyName"].Value,Globals.LocalCopyName);
		}

		private static string ReadConfig(XmlNode n, string key)
		{
			XmlNode keyN = n.SelectSingleNode(key);
			if(keyN != null)
			{
				XmlAttribute a = keyN.Attributes["value"];
				return keyN.Attributes["value"].Value;
			}
			else
				return n.SelectSingleNode("../Defaults/"+key).Attributes["value"].Value;
		}

		#region IStorage Members

		public System.IO.Stream OpenRead(string Location, string Name)
		{
			return lrs.OpenRead(Location,Name);
		}

		public System.IO.Stream OpenWrite(string Location, string Name)
		{
			return lrs.OpenWrite(Location,Name);
		}

		public bool LocationExists(string Location)
		{
			return lrs.LocationExists(Location);
		}

		public bool Exists(string Location, string Name)
		{
			return lrs.Exists(Location,Name);
		}

		public string[] ElementsIn(string Location)
		{
			return lrs.ElementsIn(Location);
		}

		public void CreateLocation(string Location)
		{
			lrs.CreateLocation(Location);
		}

		public void DestroyLocation(string Location, bool checkEmpty)
		{
			lrs.DestroyLocation(Location,checkEmpty);
		}

		public void Delete(string Location, string Name)
		{
			lrs.Delete(Location, Name);
		}

		#endregion
	}
}
